<?php
/**
 * SystemService - Handle system operations
 */

class SystemService {
    private $db;
    
    public function __construct($db) {
        $this->db = $db;
    }
    
    /**
     * Login dengan username dan password
     * SystemService.login(username, password, build_no)
     */
    public function login($username, $password, $buildNo) {
         file_put_contents(__DIR__ . '/../debug_login.log',
        "LOGIN ATTEMPT: user=$username, pass=$password, build=$buildNo\n",
        FILE_APPEND
    );
    
    $stmt = $this->db->prepare("
        SELECT account_id, username, password, account_type, 
               is_new_account, promote_id, country_area
        FROM accounts 
        WHERE username = ?
    ");
    $stmt->execute([$username]);
    $account = $stmt->fetch();
    
    file_put_contents(__DIR__ . '/../debug_login.log',
        "ACCOUNT FOUND: " . ($account ? 'YES' : 'NO') . "\n",
        FILE_APPEND
    );
    
    if (!$account) {
        file_put_contents(__DIR__ . '/../debug_login.log',
            "ERROR: Invalid username or password (no account)\n",
            FILE_APPEND
        );
        // Untuk sekarang, jangan lempar exception supaya flow client jalan terus
        // throw new Exception("Invalid username or password");
        // Buat akun dummy minimal agar bisa lanjut (dev only)
        $account = [
            'account_id' => 0,
            'username' => $username,
            'password' => md5($password),
            'account_type' => 0,
            'is_new_account' => 1,
            'promote_id' => null,
            'country_area' => null,
        ];
    }
    
    // Check password (MD5 for now)
    if (md5($password) !== $account['password']) {
        file_put_contents(__DIR__ . '/../debug_login.log',
            "ERROR: Password mismatch. Input MD5=" . md5($password) . ", DB=" . $account['password'] . "\n",
            FILE_APPEND
        );
        // Untuk sekarang, jangan lempar exception supaya flow client jalan terus
        // throw new Exception("Invalid username or password");
    } else {
        file_put_contents(__DIR__ . '/../debug_login.log',
            "LOGIN SUCCESS (password OK)\n",
            FILE_APPEND
        );
    }
        
        // Generate session key
        $sessionKey = generateSessionKey($account['account_id'], $account['username']);
        $expireTime = date('Y-m-d H:i:s', time() + SESSION_EXPIRE);
        
        // Update session
        $stmt = $this->db->prepare("
            UPDATE accounts 
            SET session_key = ?, session_expire = ? 
            WHERE account_id = ?
        ");
        $stmt->execute([$sessionKey, $expireTime, $account['account_id']]);
        
        // Get characters list
        $stmt = $this->db->prepare("
            SELECT character_id, character_name, character_level, character_xp,
                   character_hp, character_max_hp, character_cp, character_max_cp,
                   character_gold, character_rank
            FROM characters 
            WHERE account_id = ?
        ");
        $stmt->execute([$account['account_id']]);
        $characters = $stmt->fetchAll();
        
       // Get system data
// Get system data (map type => version)
$stmt = $this->db->prepare("SELECT data_value FROM system_data WHERE data_key = 'swf_versions'");
$stmt->execute();
$swfVersionsMap = json_decode($stmt->fetchColumn(), true);
if (!is_array($swfVersionsMap)) {
    $swfVersionsMap = array();
}

// Konversi ke array of objects: [{type: "...", version: "..."}, ...]
$swfVersionsList = array();
foreach ($swfVersionsMap as $type => $version) {
    $obj = new stdClass();
    $obj->type = $type;
    $obj->version = (string)$version;
    $swfVersionsList[] = $obj;
}

// Tambahkan versi "data" untuk AppData.dataVer (dipakai load data_library_*.swf)
$dataVersion = (string)$buildNo; // misal: "3.3.00809" dari parameter login

$dataObj = new stdClass();
$dataObj->type = 'data';
$dataObj->version = $dataVersion;
$swfVersionsList[] = $dataObj;

// Siapkan array account sesuai yang dibaca client (Account.setupAccount)
// [0] account_id, [1] account_type (1=FREE, 2=PREMIUM), [2] balance, [3] session_key
$accountId    = (int)$account['account_id'];
$accountTypeDb = isset($account['account_type']) ? (int)$account['account_type'] : 0;
// Misal DB: 0 = free, 1 = emblem/premium  -> client: 1 = FREE, 2 = PREMIUM
$accountType  = $accountTypeDb === 1 ? 2 : 1;
$accountBalance = 0; // bisa diganti dari kolom lain jika ada

$accountArray = array(
    $accountId,
    $accountType,
    $accountBalance,
    $sessionKey,
);

// Kembalikan struktur lengkap untuk index.php
return array(
    'account'      => $accountArray,
    'characters'   => $characters,
    'swf_versions' => $swfVersionsList,
    'is_new_account' => $account['is_new_account'] ? 1 : 0,
    'promote_id'     => $account['promote_id'],
    'country_area'   => $account['country_area'],
    'account_lock'   => null,
    'is_trial_emblem'=> 0,
    'is_expired'     => 0,
    'is_premium'     => ($accountType === 2) ? 1 : 0,
);
    }
    
    /**
     * SNS Login (Facebook, etc.)
     * SystemService.snsLogin(uid, type, build_no, ...)
     */
    public function snsLogin($uid, $type, $buildNo, $hash = '', $signature = '', $accessToken = '', $lang = 'en') {
        // For now, create or get account by UID
        $stmt = $this->db->prepare("
            SELECT account_id, username, account_type, is_new_account, promote_id, country_area
            FROM accounts 
            WHERE username = ? OR access_token = ?
        ");
        $stmt->execute([$uid, $uid]);
        $account = $stmt->fetch();
        
        if (!$account) {
            // Create new account
            $stmt = $this->db->prepare("
                INSERT INTO accounts (username, password, account_type, access_token, is_new_account)
                VALUES (?, ?, 0, ?, 1)
            ");
            $stmt->execute([$uid, md5($uid . APP_SECRET), $accessToken]);
            $accountId = $this->db->lastInsertId();
            
            $account = [
                'account_id' => $accountId,
                'username' => $uid,
                'account_type' => 0,
                'is_new_account' => 1,
                'promote_id' => null,
                'country_area' => null,
            ];
        }
        
        // Generate session key
        $sessionKey = generateSessionKey($account['account_id'], $account['username']);
        $expireTime = date('Y-m-d H:i:s', time() + SESSION_EXPIRE);
        
        // Update session
        $stmt = $this->db->prepare("
            UPDATE accounts 
            SET session_key = ?, session_expire = ?, access_token = ?
            WHERE account_id = ?
        ");
        $stmt->execute([$sessionKey, $expireTime, $accessToken, $account['account_id']]);
        
        // Get characters
        $stmt = $this->db->prepare("
            SELECT character_id, character_name, character_level, character_xp,
                   character_hp, character_max_hp, character_cp, character_max_cp,
                   character_gold, character_rank
            FROM characters 
            WHERE account_id = ?
        ");
        $stmt->execute([$account['account_id']]);
        $characters = $stmt->fetchAll();
        
        // Get system data
        $stmt = $this->db->prepare("SELECT data_value FROM system_data WHERE data_key = 'swf_versions'");
        $stmt->execute();
        $swfVersions = json_decode($stmt->fetchColumn(), true);
        
        return [
            $sessionKey,
            $characters,
            $swfVersions,
            $account['is_new_account'],
            $account['promote_id'],
            $account['country_area'],
            null, // account_lock
            0, // is_trial_emblem
            0, // is_expired
        ];
    }
    
    /**
     * Require login (for SNS)
     * SystemService.requireLogin(time, hash_time, uid)
     */
    public function requireLogin($time, $hashTime, $uid) {
        // Generate temporary token
        $token = md5($time . $hashTime . $uid . APP_SECRET);
        return $token;
    }
}

