<?php
/**
 * Database connection helper
 */

function getDBConnection() {
    static $db = null;
    
    if ($db === null) {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ];
            
            $db = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            throw new Exception("Database connection failed: " . $e->getMessage());
        }
    }
    
    return $db;
}

/**
 * Generate session key
 */
function generateSessionKey($accountId, $username) {
    return md5($accountId . $username . time() . APP_SECRET);
}

/**
 * Validate session key
 */
function validateSessionKey($sessionKey) {
    $db = getDBConnection();
    $stmt = $db->prepare("
        SELECT account_id, username, account_type 
        FROM accounts 
        WHERE session_key = ? 
        AND session_expire > NOW()
    ");
    $stmt->execute([$sessionKey]);
    return $stmt->fetch();
}

